/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsPlayer;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.player.DelayedSoundPlayer;
import eu.ha3.presencefootsteps.util.BlockReport;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import eu.ha3.presencefootsteps.world.BiomeVarianceLookup;
import eu.ha3.presencefootsteps.world.GolemLookup;
import eu.ha3.presencefootsteps.world.HeuristicStateLookup;
import eu.ha3.presencefootsteps.world.Index;
import eu.ha3.presencefootsteps.world.LocomotionLookup;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.StateLookup;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;

public record Isolator(Variator variator, Index<class_1297, Locomotion> locomotions, HeuristicStateLookup heuristics, Lookup<class_1299<?>> golems, Lookup<class_2680> blocks, Index<class_2960, BiomeVarianceLookup.BiomeVariance> biomes, Lookup<class_3414> primitives, AcousticLibrary acoustics) implements BlockReport.Reportable
{
    private static final class_2960 BLOCK_MAP = PresenceFootsteps.id("config/blockmap.json");
    private static final class_2960 BIOME_MAP = PresenceFootsteps.id("config/biomevariancemap.json");
    private static final class_2960 GOLEM_MAP = PresenceFootsteps.id("config/golemmap.json");
    private static final class_2960 LOCOMOTION_MAP = PresenceFootsteps.id("config/locomotionmap.json");
    private static final class_2960 PRIMITIVE_MAP = PresenceFootsteps.id("config/primitivemap.json");
    public static final class_2960 ACOUSTICS = PresenceFootsteps.id("config/acoustics.json");
    private static final class_2960 VARIATOR = PresenceFootsteps.id("config/variator.json");

    public Isolator(SoundEngine engine) {
        this(new Variator(), new LocomotionLookup(engine.getConfig()), new HeuristicStateLookup(), new GolemLookup(), new StateLookup(), new BiomeVarianceLookup(), new PrimitiveLookup(), new AcousticsPlayer(new DelayedSoundPlayer(engine.soundPlayer)));
    }

    public boolean load(class_3300 manager) {
        boolean hasConfigurations = false;
        hasConfigurations |= ResourceUtils.forEach(BLOCK_MAP, manager, this.blocks()::load);
        hasConfigurations |= ResourceUtils.forEach(BIOME_MAP, manager, this.biomes()::load);
        hasConfigurations |= ResourceUtils.forEach(GOLEM_MAP, manager, this.golems()::load);
        hasConfigurations |= ResourceUtils.forEach(PRIMITIVE_MAP, manager, this.primitives()::load);
        hasConfigurations |= ResourceUtils.forEach(LOCOMOTION_MAP, manager, this.locomotions()::load);
        hasConfigurations |= ResourceUtils.forEach(ACOUSTICS, manager, reader -> AcousticsFile.read(reader, this.acoustics()::addAcoustic, false));
        return hasConfigurations |= ResourceUtils.forEach(VARIATOR, manager, this.variator()::load);
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.object(() -> {
            writer.object("blocks", () -> this.blocks().writeToReport(full, writer, groups));
            writer.object("entities", () -> this.locomotions().writeToReport(full, writer, groups));
            writer.object("primitives", () -> this.primitives().writeToReport(full, writer, groups));
        });
    }
}

